/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.PositionTrackingInputStream;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;

public class LiteralStream
extends InputStream {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final InputStream stream;

    public LiteralStream(ClassLoader loader, String path) {
        this.stream = loader.getResourceAsStream(path);
        if (this.stream == null) {
            String msg = Strings.fmt((String)"Failed to load literal resource \"%s\".", (Object[])new Object[]{path});
            throw new InputOutputException(msg);
        }
    }

    public LiteralStream(String valueText) {
        byte[] bytes = valueText.getBytes(UTF8_CHARSET);
        ByteArrayInputStream bstream = new ByteArrayInputStream(bytes);
        this.stream = new PositionTrackingInputStream((InputStream)bstream);
    }

    @Override
    public int read() {
        try {
            return this.stream.read();
        }
        catch (IOException ex) {
            String msg = "Failed to read literal data.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    @Override
    public int read(byte[] b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] b, int off, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long skip(long n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int available() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to close literal data stream.", (Object[])new Object[0]);
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.stream.mark(readlimit);
    }

    @Override
    public synchronized void reset() {
        try {
            this.stream.reset();
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to reset literal data stream.", (Object[])new Object[0]);
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    public static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 13 || c == 10;
    }

    public void skipWhitespace() {
        int c;
        do {
            this.mark(1);
        } while (LiteralStream.isWhitespace(c = this.read()));
        this.reset();
    }

    public void expectCharacter(int expected) {
        this.expectCharacter(expected, -1);
    }

    public int expectCharacter(int expected1, int expected2) {
        int c;
        while ((c = this.read()) != -1) {
            if (LiteralStream.isWhitespace(c)) continue;
            if (c != expected1 && c != expected2) break;
            return c;
        }
        Object msg = Strings.fmt((String)"Expected \"%c\"", (Object[])new Object[]{expected1});
        if (expected2 != -1) {
            msg = (String)msg + Strings.fmt((String)" or \"%c\"", (Object[])new Object[]{expected2});
        }
        msg = (String)msg + ", but found ";
        msg = (String)msg + (c == -1 ? "end-of-file" : Strings.fmt((String)"\"%c\"", (Object[])new Object[]{c}));
        String lineColMsg = this.getLineColMsg();
        if (lineColMsg != null) {
            msg = (String)msg + ", " + lineColMsg;
        }
        msg = (String)msg + ".";
        throw new InputOutputException((String)msg);
    }

    public boolean matchCharacter(int expected) {
        boolean match;
        int c;
        do {
            this.mark(1);
        } while (LiteralStream.isWhitespace(c = this.read()));
        if (c == -1) {
            Object msg = "Expected a non-whitespace character, but found end-of-file";
            String lineColMsg = this.getLineColMsg();
            if (lineColMsg != null) {
                msg = (String)msg + ", " + lineColMsg;
            }
            msg = (String)msg + ".";
            throw new InputOutputException((String)msg);
        }
        boolean bl = match = c == expected;
        if (!match) {
            this.reset();
        }
        return match;
    }

    public String getLineColMsg() {
        if (!(this.stream instanceof PositionTrackingInputStream)) {
            return null;
        }
        PositionTrackingInputStream ptstream = (PositionTrackingInputStream)this.stream;
        long line = ptstream.getPrevLine();
        long col = ptstream.getPrevCol();
        Assert.check((line >= 1L ? 1 : 0) != 0);
        Assert.check((col >= 1L ? 1 : 0) != 0);
        return Strings.fmt((String)"at line %d column %d", (Object[])new Object[]{line, col});
    }
}

