/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.util;

import org.eclipse.jgit.internal.JGitText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CleanupService {
    private static final Logger LOG = LoggerFactory.getLogger(CleanupService.class);
    private static final Object LOCK = new Object();
    private static CleanupService INSTANCE;
    private final boolean isOsgi;
    private JGitText jgitText;
    private Runnable cleanup;

    public CleanupService() {
        this.isOsgi = true;
        CleanupService.setInstance(this);
    }

    private CleanupService(boolean isOsgi) {
        this.isOsgi = isOsgi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setInstance(CleanupService service) {
        Object object = LOCK;
        synchronized (object) {
            INSTANCE = service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CleanupService getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new CleanupService(false);
            }
            return INSTANCE;
        }
    }

    void start() {
    }

    void register(Runnable cleanUp) {
        if (this.isOsgi) {
            this.cleanup = cleanUp;
        } else {
            this.jgitText = JGitText.get();
            assert (this.jgitText != null);
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        cleanUp.run();
                    }
                    finally {
                        this.jgitText = null;
                    }
                }));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    void shutDown() {
        if (this.isOsgi && this.cleanup != null) {
            Runnable r = this.cleanup;
            this.cleanup = null;
            try {
                r.run();
            }
            catch (RuntimeException e) {
                LOG.error(JGitText.get().shutdownCleanupFailed, (Throwable)e);
            }
        }
    }
}

