/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCServer.java 72894 2013-09-27 10:34:01Z supol $
 */

package com.sun.ts.tests.websocket.spec.application.containers;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint("/srv")
public class WSCServer {
	@OnMessage
	public String onMessage(String msg, Session session) {
		WebSocketContainer container;
		container = session.getContainer();
		msg = String.valueOf(container.hashCode());
		return msg;
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		t.printStackTrace(); // Write to error log, too
		String message = "Exception: " + IOUtil.printStackTrace(t);
		session.getBasicRemote().sendText(message);
	}
}
