/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: OnMessageServerEndpoint.java 74503 2015-05-21 15:13:10Z jsupol $
 */

package com.sun.ts.tests.websocket.negdep.onmessage.srv.binarybytebufferint;

import java.io.IOException;
import java.nio.ByteBuffer;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint("/invalid")
public class OnMessageServerEndpoint {

	@OnMessage
	public String echo(ByteBuffer buffer, int finito) throws IOException {
		String s = null;
		s = IOUtil.byteBufferToString(buffer);
		return s;
	}

	@OnError
	public void onError(Session session, Throwable thr) throws IOException {
		thr.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(thr);
		session.getBasicRemote().sendText(message);
	}
}
