/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: OnMessageClientEndpoint.java 74509 2015-05-25 13:33:41Z jsupol $
 */

package com.sun.ts.tests.websocket.negdep.onmessage.client.nodecoder;

//import java.nio.ByteBuffer;

import java.nio.ByteBuffer;

import javax.websocket.ClientEndpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedByteBufferClientEndpoint;
import com.sun.ts.tests.websocket.negdep.StringHolder;

/**
 * There is no tell whether @OnMessage on this endpoint is accepting binary or
 * text messages, there is not Decoder.
 */
@ClientEndpoint
public class OnMessageClientEndpoint extends AnnotatedByteBufferClientEndpoint {

	@OnMessage
	public void onMessage(StringHolder holder) {
		clientEndpoint.onMessage(ByteBuffer.wrap(holder.toString().getBytes()));
	}

	@OnError
	public void onError(Session session, Throwable t) {
		clientEndpoint.onError(session, t);
	}

	@OnOpen
	public void onOpen(Session session, EndpointConfig config) {
		clientEndpoint.onOpen(session, config, false);
	}
}
