/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: WSByteBufferPartialServer.java 72135 2013-06-13 09:13:43Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.websocketmessage;

import java.io.IOException;
import java.nio.ByteBuffer;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint("/partialbytebuffer")
public class WSByteBufferPartialServer {
	@OnMessage
	public String echo(ByteBuffer buf, boolean bol) {
		return new StringBuilder(IOUtil.byteBufferToString(buf)).append("(")
				.append(bol).append(")").toString();
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		System.out.println("@OnError in " + getClass().getName());
		t.printStackTrace(); // Write to error log, too
		String message = "Exception: " + IOUtil.printStackTrace(t);
		session.getBasicRemote().sendText(message);
	}
}
