/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: PongMessageHandler.java 73930 2014-08-01 17:07:43Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.server;

import java.io.IOException;

import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.util.IOUtil;

public class PongMessageHandler implements MessageHandler.Whole<PongMessage> {

	protected Session session;
	public static final String HANDLER_SAYS = "PongMessageHandler says: ";

	public PongMessageHandler(Session session) {
		this.session = session;
	}

	@Override
	public void onMessage(PongMessage pong) {
		String msg = null;
		try {
			msg = IOUtil.byteBufferToString(pong.getApplicationData());
			session.getBasicRemote().sendText(HANDLER_SAYS + msg);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

}
