/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: InputStreamMessageHandler.java 73930 2014-08-01 17:07:43Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.server;

import java.io.IOException;
import java.io.InputStream;

import javax.websocket.MessageHandler;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.util.IOUtil;

public class InputStreamMessageHandler implements
		MessageHandler.Whole<InputStream> {

	protected Session session;
	public static final String HANDLER_SAYS = "InputStreamMessageHandler says: ";

	public InputStreamMessageHandler(Session session) {
		super();
		this.session = session;
	}

	@Override
	public void onMessage(InputStream message) {
		String msg = null;
		try {
			msg = IOUtil.readFromStream(message);
			session.getBasicRemote().sendText(HANDLER_SAYS + msg);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
}
