/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: StringListWholeMessageHandler.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.client;

import javax.websocket.MessageHandler;

import com.sun.ts.tests.websocket.ee.javax.websocket.session11.common.StringList;

public class StringListWholeMessageHandler implements MessageHandler.Whole<StringList>{

	MixedProgramaticEndpoint endpoint;
	public static final String HANDLER_SAYS = "LinkedListWholeMessageHandler says: ";
	
	public StringListWholeMessageHandler(MixedProgramaticEndpoint endpoint) {
		super();
		this.endpoint = endpoint;
	}

	@Override
	public void onMessage(StringList message) {
		endpoint.onMessage(HANDLER_SAYS + message.get(0).toString());
	}
}
