/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: StringBeanMessageHandler.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.client;

import javax.websocket.MessageHandler;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;

public class StringBeanMessageHandler implements MessageHandler.Whole<StringBean>{

	MixedProgramaticEndpoint endpoint;
	
	public static final String HANDLER_SAYS = "StringBeanMessageHandler says: ";

	public StringBeanMessageHandler(MixedProgramaticEndpoint endpoint) {
		this.endpoint = endpoint;
	}	
	
	@Override
	public void onMessage(StringBean message) {	
		endpoint.onMessage(HANDLER_SAYS + message.get());
	}

}
