/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: LinkedListHashSetMessageHandler.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.client;

import java.util.HashSet;
import java.util.LinkedList;

import javax.websocket.MessageHandler;

import com.sun.ts.tests.websocket.ee.javax.websocket.session11.common.ListHashSetTextEncoder;

public class LinkedListHashSetMessageHandler implements
		MessageHandler.Whole<LinkedList<HashSet<String>>> {

	MixedProgramaticEndpoint endpoint;
	public static final String HANDLER_SAYS = "LinkedListHashSetMessageHandler says: ";

	public LinkedListHashSetMessageHandler(MixedProgramaticEndpoint endpoint) {
		super();
		this.endpoint = endpoint;
	}

	@Override
	public void onMessage(LinkedList<HashSet<String>> arg0) {
		endpoint.onMessage(HANDLER_SAYS + ListHashSetTextEncoder.listHashSetToString(arg0));
	}

}
