/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: AppConfig.java 71542 2013-04-10 15:02:49Z supol $
 */
package com.sun.ts.tests.websocket.ee.javax.websocket.server.serverapplicationconfiginlib;

import java.util.HashSet;
import java.util.Set;

import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpointConfig;

import com.sun.ts.tests.websocket.ee.javax.websocket.server.serverapplicationconfig.UsedServerEndpointConfig;
import com.sun.ts.tests.websocket.ee.javax.websocket.server.serverapplicationconfig.WSUsedServer;

public class AppConfig implements ServerApplicationConfig {

	@Override
	public Set<ServerEndpointConfig> getEndpointConfigs(
			Set<Class<? extends Endpoint>> endpointClasses) {
		Set<ServerEndpointConfig> set = new HashSet<ServerEndpointConfig>();
		set.add(new UsedServerEndpointConfig());
		return set;
	}

	@Override
	public Set<Class<?>> getAnnotatedEndpointClasses(Set<Class<?>> scanned) {
		Set<Class<?>> set = new HashSet<Class<?>>();
		set.add(WSUsedServer.class);
		return set;
	}
}
