/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: PathParamConfigurator.java 72308 2013-07-09 10:57:45Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.server.handshakerequest;

import java.util.List;
import java.util.Map;

import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import javax.websocket.server.ServerEndpointConfig.Configurator;

public class PathParamConfigurator extends Configurator {

	@Override
	public void modifyHandshake(ServerEndpointConfig sec,
			HandshakeRequest request, HandshakeResponse response) {
		Map<String, List<String>> map = request.getParameterMap();
		response.getHeaders().putAll(map);
	}
}
