/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: GetUserPrincipalNotAuthenticatedConfigurator.java 72309 2013-07-09 11:33:22Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.server.handshakerequest;

import java.security.Principal;
import java.util.Arrays;

import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import javax.websocket.server.ServerEndpointConfig.Configurator;

public class GetUserPrincipalNotAuthenticatedConfigurator extends Configurator {
	static final String KEY = "GetUserPrincipalNotAuthenticatedConfigurator";

	@Override
	public void modifyHandshake(ServerEndpointConfig sec,
			HandshakeRequest request, HandshakeResponse response) {
		Principal principal = request.getUserPrincipal();
		String value = String.valueOf(principal == null);
		response.getHeaders().put(KEY, Arrays.asList(value));
	}
}
