/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: GetRequestUriConfigurator.java 72308 2013-07-09 10:57:45Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.server.handshakerequest;

import java.net.URI;
import java.util.Arrays;

import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import javax.websocket.server.ServerEndpointConfig.Configurator;

public class GetRequestUriConfigurator extends Configurator {
	static final String KEY = "GetRequestUriConfigurator";

	@Override
	public void modifyHandshake(ServerEndpointConfig sec,
			HandshakeRequest request, HandshakeResponse response) {
		URI uri = request.getRequestURI();
		String sUri = uri == null ? "NULL" : uri.toASCIIString();
		response.getHeaders().put(KEY, Arrays.asList(sUri));
	}
}
