/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.async;

import java.io.IOException;
import java.util.concurrent.ExecutionException;

import javax.websocket.EncodeException;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.BinaryStreamCoderBool;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.BinaryStreamCoderByte;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.BinaryStreamCoderChar;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.BinaryStreamCoderDouble;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.BinaryStreamCoderFloat;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.BinaryStreamCoderInt;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.BinaryStreamCoderLong;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.BinaryStreamCoderShort;

@ServerEndpoint(value = "/binarystream", encoders = {
		BinaryStreamCoderBool.class, BinaryStreamCoderByte.class,
		BinaryStreamCoderChar.class, BinaryStreamCoderDouble.class,
		BinaryStreamCoderInt.class, BinaryStreamCoderLong.class,
		BinaryStreamCoderFloat.class, BinaryStreamCoderShort.class })
public class WSCBinaryStreamServer extends WSCCommonServer {

	@OnMessage
	public void onMessage(String msg, Session session) throws IOException,
			EncodeException, InterruptedException, ExecutionException {
		super.onMessage(msg, session);
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		super.onError(session, t);
	}
}
