/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: PongMessageClientEndpoint.java 72867 2013-09-13 14:45:11Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint;

import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.BinaryAndTextClientEndpoint;
import com.sun.ts.tests.websocket.common.util.IOUtil;

public class PongMessageClientEndpoint extends BinaryAndTextClientEndpoint {
	@Override
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
		session.addMessageHandler(new MessageHandler.Whole<PongMessage>() {
			@Override
			public void onMessage(PongMessage message) {
				String msg = IOUtil.byteBufferToString(message
						.getApplicationData());
				PongMessageClientEndpoint.this.onMessage(msg);
			}
		});
	}
}
