/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: TextStreamDecoderEndpointConfig.java 71484 2013-04-08 16:05:16Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.programaticcoder;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Extension;
import javax.websocket.server.ServerEndpointConfig;

import com.sun.ts.tests.websocket.ee.javax.websocket.coder.InitDestroyTextStreamDecoder;

public class TextStreamDecoderEndpointConfig implements ServerEndpointConfig {

	@Override
	public Map<String, Object> getUserProperties() {
		return Collections.emptyMap();
	}

	@Override
	public Class<?> getEndpointClass() {
		return WSCTextStreamDecoderServer.class;
	}

	@Override
	public String getPath() {
		return "/textstreamdecoder";
	}

	@Override
	public List<String> getSubprotocols() {
		return Collections.emptyList();
	}

	@Override
	public List<Extension> getExtensions() {
		return Collections.emptyList();
	}

	@Override
	public Configurator getConfigurator() {
		return new ServerEndpointConfig.Configurator() {
		};
	}

	@Override
	public List<Class<? extends Encoder>> getEncoders() {
		return Collections.emptyList();
	}

	@Override
	public List<Class<? extends Decoder>> getDecoders() {
		Class<? extends Decoder> clz = InitDestroyTextStreamDecoder.class;
		List<Class<? extends Decoder>> list = new LinkedList<Class<? extends Decoder>>();
		list.add(clz);
		return list;
	}

}
