/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: SetHeadersConfigurator.java 72280 2013-07-02 14:16:57Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.handshakeresponse;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import javax.websocket.server.ServerEndpointConfig.Configurator;

public class SetHeadersConfigurator extends Configurator {
	static final String KEY = "aFirstKey";
	static final String[] HEADERS = { "header1", "header2", "header3",
			"header4", "header5", "header6", "header7", "header8" };

	@Override
	public void modifyHandshake(ServerEndpointConfig sec,
			HandshakeRequest request, HandshakeResponse response) {
		Map<String, List<String>> map = request.getHeaders();
		response.getHeaders().putAll(map);
		response.getHeaders().put(KEY, Arrays.asList(HEADERS));
	}
}
