/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: AppConfig.java 72835 2013-09-09 16:00:58Z supol $
 */
package com.sun.ts.tests.websocket.ee.javax.websocket.endpoint.server;

import java.util.HashSet;
import java.util.Set;

import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpointConfig;

public class AppConfig implements ServerApplicationConfig {

	@Override
	public Set<ServerEndpointConfig> getEndpointConfigs(
			Set<Class<? extends Endpoint>> endpointClasses) {
		ServerEndpointConfig closeConfig = ServerEndpointConfig.Builder.create(				
				WSCCloseServerEndpoint.class, "/close").build();
		
		ServerEndpointConfig errorConfig = ServerEndpointConfig.Builder.create(
				WSCErrorServerEndpoint.class, "/error").build();		

		Set<ServerEndpointConfig> set = new HashSet<ServerEndpointConfig>();
		set.add(closeConfig);
		set.add(errorConfig);
		return set;
	}

	@Override
	public Set<Class<?>> getAnnotatedEndpointClasses(Set<Class<?>> scanned) {
		Set<Class<?>> set = new HashSet<Class<?>>();
		set.add(WSCMsgServer.class);
		return set;
	}
}
