/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: StringBeanBinaryStreamEncoder.java 70531 2013-03-10 14:38:04Z djiao $
 */

package com.sun.ts.tests.websocket.common.stringbean;

import java.io.IOException;
import java.io.OutputStream;
import javax.websocket.EncodeException;
import javax.websocket.Encoder.BinaryStream;
import javax.websocket.EndpointConfig;

public class StringBeanBinaryStreamEncoder implements BinaryStream<StringBean> {

    @Override
    public void init(EndpointConfig config) {
    }

    @Override
    public void encode(StringBean bean, OutputStream stream)
            throws EncodeException, IOException {
        stream.write(bean.get().getBytes());
    }

    @Override
    public void destroy() {
    }
}
