/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: StringBeanBinaryDecoder.java 70531 2013-03-10 14:38:04Z djiao $
 */

package com.sun.ts.tests.websocket.common.stringbean;

import java.nio.ByteBuffer;
import javax.websocket.DecodeException;
import javax.websocket.Decoder.Binary;
import javax.websocket.EndpointConfig;

public class StringBeanBinaryDecoder implements Binary<StringBean> {
            
    @Override
	public void init(EndpointConfig config) {
	}

	@Override
	public StringBean decode(ByteBuffer arg0) throws DecodeException {
		return new StringBean(new String(arg0.array()));
	}

	@Override
	public boolean willDecode(ByteBuffer arg0) {
		return true;
	}

    @Override
	public void destroy() {
	}
}
