/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: StringBean.java 70173 2013-02-21 17:03:37Z supol $
 */

package com.sun.ts.tests.websocket.common.stringbean;

/**
 * This is the object which standard implementation does not have a provider
 * for, even though its some simple String holder. It can also be used as mutable 
 * string.
 */
public class StringBean {
	private String value;

	public String get() {
		return value;
	}

	public void set(String value) {
		this.value = value;
	}
	
	@Override
	public String toString() {
		return "StringBean. To get a value, use rather #get() method.";
	}

	public StringBean(String value) {
		super();
		this.value = value;
	}
}