/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: WaitingSendHandler.java 72626 2013-08-20 13:31:59Z supol $
 */

package com.sun.ts.tests.websocket.common.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

import javax.websocket.SendHandler;
import javax.websocket.SendResult;

/**
 * This SendHandler implementation is used to wait maximum given number of
 * seconds for SendResult and onResult method called
 * 
 * The main goal is to pass SendHandler object to a caller code
 */
public class WaitingSendHandler implements SendHandler {
	private volatile CountDownLatch latch;
	private volatile SendResult result = null;

	public WaitingSendHandler() {
		latch = new CountDownLatch(1);
	}

	public SendResult waitForResult(long seconds) {
		try {
			latch.await(seconds, TimeUnit.SECONDS);
		} catch (InterruptedException e) {
			throw new RuntimeException("Wait has been interrupted", e);
		}
		if (latch != null && latch.getCount() != 0)
			throw new IllegalStateException(
					"onResult has not been called on time");
		if (result == null)
			throw new IllegalStateException("SendResult is null");
		return result;
	}

	@Override
	public void onResult(SendResult result) {
		this.result = result;
		latch.countDown();
	}

}
