/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: StringPongMessage.java 72898 2013-09-27 15:18:48Z supol $
 */

package com.sun.ts.tests.websocket.common.impl;

import java.nio.ByteBuffer;

import javax.websocket.PongMessage;

public class StringPongMessage implements PongMessage {

	protected String message;

	public StringPongMessage(String message) {
		if (message.length() > 125)
			throw new RuntimeException("StringPongMessage is too long");
		this.message = message;
	}

	@Override
	public ByteBuffer getApplicationData() {
		return ByteBuffer.wrap(message.getBytes());
	}

}
