/*
 * Copyright (c) 2013, 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: AnnotatedClientEndpoint.java 73920 2014-07-30 16:59:06Z supol $
 */

package com.sun.ts.tests.websocket.common.client;

import java.util.concurrent.CountDownLatch;

import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

/**
 * For tests where the annotated client endpoint is to be tested, this
 * predefined endpoint can be used. Though merely a bridge to a ClientEndpoint
 * which can be used to connect to server using it in
 * {@link WebSocketContainer#connectToServer(javax.websocket.Endpoint, javax.websocket.ClientEndpointConfig, java.net.URI)}
 * , this annotated endpoint is used to test the {@link OnMessage},
 * {@link OnError}, {@link OnOpen}, and {@link OnClose} are being called.
 * 
 * </p> Note that {@link ClientEndpoint} annotation is to be add to subclasses,
 * and {@link OnMessage}, {@link OnError}, {@link OnOpen}, and {@link OnClose}
 * are to be overridden when convenient.
 */
public abstract class AnnotatedClientEndpoint<DATATYPE> {

	protected ClientEndpoint<DATATYPE> clientEndpoint;

	public AnnotatedClientEndpoint(ClientEndpoint<DATATYPE> endpoint) {
		this.clientEndpoint = endpoint;
	}

	//@OnOpen
	public void onOpen(Session session, EndpointConfig config) {
		clientEndpoint.onOpen(session, config, false);
	}

	//@OnMessage
	public void onMessage(DATATYPE msg) {
		clientEndpoint.onMessage(msg);
	}

	//@OnClose
	public void onClose(Session session, CloseReason closeReason) {
		clientEndpoint.onClose(session, closeReason);
	}

	//@OnError
	public void onError(Session session, Throwable t) {
		clientEndpoint.onError(session, t);
	}
	
	public CountDownLatch getCountDownLatch() {
		return ClientEndpoint.getCountDownLatch();
	}

	public StringBuffer getMessageBuilder() {
		return ClientEndpoint.getMessageBuilder();
	}
	
	public Throwable getLastError() {
		return ClientEndpoint.getLastError();
	}	
}
