/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.sun.ts.tests.servlet.spec.annotationservlet.weblistener;

import java.util.ArrayList;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.annotation.WebListener;

@WebListener(value = "HttpSessionAttributeListener")
public final class HSAttributeListener implements HttpSessionAttributeListener {


    public void attributeAdded(HttpSessionBindingEvent event) {
        System.out.println("in HSAttributeListener.attributeAdded");
        ArrayList al = null;
        
        al = (ArrayList) event.getSession().getServletContext().getAttribute("HSAList");
        if (al == null) {
            al = new ArrayList();
        }
        al.add("HSAttributeListener.attributeAdded");
        event.getSession().getServletContext().setAttribute("HSAList", al);
    }


    public void attributeRemoved(HttpSessionBindingEvent event) {
        System.out.println("in HSAttributeListener.attributeRemoved");
        ArrayList al = null;
        
        al = (ArrayList) event.getSession().getServletContext().getAttribute("HSAList");
        if (al == null) {
            al = new ArrayList();
        }
        al.add("HSAttributeListener.attributeRemoved");
        event.getSession().getServletContext().setAttribute("HSAList", al);
    }


    public void attributeReplaced(HttpSessionBindingEvent event) {
        System.out.println("in HSAttributeListener.attributeReplaced");
        ArrayList al = null;
        
        al = (ArrayList) event.getSession().getServletContext().getAttribute("HSAList");
        if (al == null) {
            al = new ArrayList();
        }
        al.add("HSAttributeListener.attributeReplaced");
        event.getSession().getServletContext().setAttribute("HSAList", al);
    }
}
