/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.javax_servlet_http.servletcontext304;

import java.util.EventListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;

public class TestListener implements ServletContextListener {

    /**
     * Receives notification that the web application initialization
     * process is starting.
     *
     * @param sce The servlet context event
     */
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();

        Boolean listener_test = true;
        String LISTENER_TEST = "LISTENER_TEST";

        /*
         * Add HttpSessionListener
         */
        context.addListener(
                com.sun.ts.tests.servlet.api.javax_servlet_http.servletcontext304.AddHttpSessionListenerClass.class);
        context.addListener(
                "com.sun.ts.tests.servlet.api.javax_servlet_http.servletcontext304.AddHttpSessionListenerString");
        try {
            EventListener hslistener =
                    context.createListener(com.sun.ts.tests.servlet.api.javax_servlet_http.servletcontext304.CreateHttpSessionListener.class);
            context.addListener(hslistener);
        } catch (ServletException ex) {
            listener_test = false;
            System.out.println("Error creating Listener CreateHttpSessionListener: " +
                    ex.getMessage());
        }
        context.setInitParameter(LISTENER_TEST, listener_test.toString());
    }

    /**
     * Receives notification that the servlet context is about to be shut down.
     *
     * @param sce The servlet context event
     */
    public void contextDestroyed(ServletContextEvent sce) {
    // Do nothing
    }
}
