/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.servlet.api.javax_servlet_http.httpservletrequest40;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(asyncSupported = true, name = "DispatchServlet", value = "/DispatchServlet", loadOnStartup = 1)
public class DispatchServlet extends HttpServlet {

  public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException{
    AsyncContext asyncContext = req.startAsync();
    asyncContext.setTimeout(0);
    asyncContext.dispatch("/TestServlet");
  }
}
