 /*
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.servletresponsewrapper30;

import java.io.IOException;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.ServletResponse;

public class IsWrapperForTest extends GenericServlet {

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void service(ServletRequest req, ServletResponse response)
            throws ServletException, IOException {
        Boolean pass = true;
        ServletResponseWrapper resWrapper1 = new TCKServletResponseWrapper(response);
        ServletResponseWrapper resWrapper2 =
                new TCKServletResponseWrapper(resWrapper1);
        ServletResponseWrapper resWrapper3 =
                new TCKServletResponseWrapper(resWrapper2);
        TCKServletResponsesubWrapper myresWrapper =
                new TCKServletResponsesubWrapper(response);

        if (!resWrapper3.isWrapperFor(resWrapper1)) {
            pass = false;
            response.getWriter().println("Test Failed: resWrapper3.isWrapperFor(resWrapper1)");
        }

        if (!resWrapper3.isWrapperFor(resWrapper2)) {
            pass = false;
            response.getWriter().println("Test Failed: resWrapper3.isWrapperFor(resWrapper2)");
        }

        if (!resWrapper3.isWrapperFor(TCKServletResponseWrapper.class)) {
            pass = false;
            response.getWriter().println("Test Failed: resWrapper3.isWrapperFor(TCKServletResponseWrapper.class)");
        }

        if (resWrapper3.isWrapperFor(myresWrapper)) {
            pass = false;
            response.getWriter().println("Test Failed: resWrapper3.isWrapperFor(myresWrapper)");
        }

        if (resWrapper3.isWrapperFor(TCKServletResponsesubWrapper.class)) {
            pass = false;
            response.getWriter().println("Test Failed: resWrapper3.isWrapperFor(TCKServletResponsesubWrapper.class)");
        }

        if (!resWrapper2.isWrapperFor(resWrapper1)) {
            pass = false;
            response.getWriter().println("Test Failed: resWrapper2.isWrapperFor(resWrapper1)");
        }

        if (!resWrapper2.isWrapperFor(TCKServletResponseWrapper.class)) {
            pass = false;
            response.getWriter().println("Test Failed: resWrapper2.isWrapperFor(TCKServletResponseWrapper.class)");
        }

        if (resWrapper2.isWrapperFor(myresWrapper)) {
            pass = false;
            response.getWriter().println("Test Failed: resWrapper2.isWrapperFor(myresWrapper)");
        }

        if (resWrapper2.isWrapperFor(TCKServletResponsesubWrapper.class)) {
            pass = false;
            response.getWriter().println("Test Failed: resWrapper2.isWrapperFor(TCKServletResponsesubWrapper.class)");
        }

        if ( resWrapper1.isWrapperFor(TCKServletResponseWrapper.class)) {
            pass = false;
            response.getWriter().println("Test Failed: resWrapper1.isWrapperFor(TCKServletResponseWrapper.class)");
        }

        if (resWrapper1.isWrapperFor(myresWrapper)) {
            pass = false;
            response.getWriter().println("Test Failed: resWrapper1.isWrapperFor(myresWrapper)");
        }

        if (resWrapper1.isWrapperFor(TCKServletResponsesubWrapper.class)) {
            pass = false;
            response.getWriter().println("Test Failed: resWrapper1.isWrapperFor(TCKServletResponsesubWrapper.class)");
        }

        if (myresWrapper.isWrapperFor(TCKServletResponseWrapper.class)) {
            pass = false;
            response.getWriter().println("Test Failed: myresWrapper.isWrapperFor(TCKServletResponseWrapper.class)");
        }

        if (myresWrapper.isWrapperFor(resWrapper1)) {
            pass = false;
            response.getWriter().println("Test Failed: myresWrapper.isWrapperFor(resWrapper1)");
        }

        if (myresWrapper.isWrapperFor(resWrapper2)) {
            pass = false;
            response.getWriter().println("Test Failed: myresWrapper.isWrapperFor(resWrapper2)");
        }

        if (myresWrapper.isWrapperFor(resWrapper3)) {
            pass = false;
            response.getWriter().println("Test Failed: myresWrapper.isWrapperFor(resWrapper3)");
        }

        if ( myresWrapper.isWrapperFor(TCKServletResponsesubWrapper.class)) {
            pass = false;
            response.getWriter().println("Test Failed: myresWrapper.isWrapperFor(TCKServletResponsesubWrapper.class)");
        }

        if (!pass) {
            response.getWriter().println("Test Failed.");
        } else {
            response.getWriter().println("Test Passed.");
        }
    }
}
