 /*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.servletrequestwrapper30;

import java.io.IOException;
import javax.servlet.*;

public class TestServletWrapper extends com.sun.ts.tests.servlet.api.javax_servlet.servletrequest30.TestServlet {

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void service(ServletRequest servletRequest,
            ServletResponse servletResponse)
            throws ServletException, IOException {
        ServletRequestWrapper wrapper =
                new ServletRequestWrapper(servletRequest);
        super.service(wrapper, servletResponse);
    }
    
    public void getServletContext(ServletRequest request, ServletResponse response)
            throws ServletException, IOException {

        ServletContext actual = request.getServletContext();
        ServletContext expected = this.getServletConfig().getServletContext();

        if (actual != expected) {
            response.getWriter().println("getServletContext() returned inconsistent result.  Test FAILED.");
        } else {
            response.getWriter().println("getServletContext() returned inconsistent result.  Test ED.");
        }
    }

}
