/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.scinitializer.getfilterregistrations;

import javax.servlet.*;
import java.io.IOException;

public final class TestFilter1 implements Filter {

        // The filter configuration object we are associated with.  If this value
        // is null, this filter instance is not currently configured.
        private FilterConfig filterConfig;

        public void doFilter(ServletRequest request, ServletResponse response,
                FilterChain chain) throws IOException, ServletException {

                if (filterConfig == null) {
                        System.out.println("doFilter of TestFilter1 was called but this filter instance is not currently configured");
                } else {
                        System.out.println("TEST_FILTER1_INVOKED");
                }

                chain.doFilter(request, response);
        }

        // Remove the filter configuration object for this filter.
        public void destroy() {
        }

        //  initialize the filter configuration object for this filter.
        public void init(FilterConfig filterConfig) {
                this.filterConfig = filterConfig;
        }
}
