/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.scinitializer.addservlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class TestListener implements ServletContextListener {

    /**
     * Receives notification that the web application initialization
     * process is starting.
     *
     * @param sce The ServletContextEvent
     */
    public void contextInitialized(ServletContextEvent sce) {
        boolean passed = true;
        ServletContext context = sce.getServletContext();
        StringBuilder log = new StringBuilder();

        try {
            context.addServlet("/testURL",
                    com.sun.ts.tests.servlet.api.javax_servlet.scinitializer.addservlet.DummyServlet.class);
            log.append("Expected UnsupportedOperationException not thrown by addServlet(String, DummyServlet.class).");
        } catch (UnsupportedOperationException ex) {
            log.append("Expected UnsupportedOperationException thrown by addServlet(String, DummyServlet.class).");
        }

        context.setAttribute("TCK_TEST_STATUS", log.toString());
        context.setAttribute("TCK_TEST_PASS_STATUS", passed);
    }

    /**
     * Receives notification that the Servlet Context is about to be shut down.
     *
     * @param sce The Servlet Context event
     */
    public void contextDestroyed(ServletContextEvent sce) {
        // Do nothing
    }
}
