/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.scinitializer.addlistener;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class TestListener implements ServletContextListener {

    /**
     * Receives notification that the web application initialization
     * process is starting.
     *
     * @param sce The ServletContextEvent
     */
    public void contextInitialized(ServletContextEvent sce) {
        boolean passed = true;
        ServletContext context = sce.getServletContext();
        StringBuilder log = new StringBuilder();

        try {
            context.addListener(
                    com.sun.ts.tests.servlet.api.javax_servlet.scinitializer.addlistener.SCListener.class);
            log.append("Expected UnsupportedOperationException not thrown by addListener(SCListener.class).");
        } catch (UnsupportedOperationException ex) {
            log.append("Expected UnsupportedOperationException thrown by addListener(SCListener.class).");
        }

        try {
            context.addListener(
                    com.sun.ts.tests.servlet.api.javax_servlet.scinitializer.addlistener.SCAttributeListener.class);
            log.append("Expected UnsupportedOperationException not thrown by addListener(SCAttributeListener.class).");
        } catch (UnsupportedOperationException ex) {
            log.append("Expected UnsupportedOperationException thrown by addListener(SCAttributeListener.class).");
        }

        try {
            context.addListener(
                    com.sun.ts.tests.servlet.api.javax_servlet.scinitializer.addlistener.SRListener.class);
            log.append("Expected UnsupportedOperationException not thrown by addListener(SRListener.class).");
        } catch (UnsupportedOperationException ex) {
            log.append("Expected UnsupportedOperationException thrown by addListener(SRListener.class).");
        }


        try {
            context.addListener(
                    com.sun.ts.tests.servlet.api.javax_servlet.scinitializer.addlistener.SRAttributeListener.class);
            log.append("Expected UnsupportedOperationException not thrown by addListener(SRAttributeListener.class).");
        } catch (UnsupportedOperationException ex) {
            log.append("Expected UnsupportedOperationException thrown by addListener(SRAttributeListener.class).");
        }

        context.setAttribute("TCK_TEST_STATUS", log.toString());
        context.setAttribute("TCK_TEST_PASS_STATUS", passed);
    }

    /**
     * Receives notification that the servlet context is about to be shut down.
     *
     * @param sce The servlet context event
     */
    public void contextDestroyed(ServletContextEvent sce) {
        // Do nothing
    }
}
