/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Test_Filter.java 62571 2011-04-18 20:58:13Z kgrucci $
 */

package com.sun.ts.tests.servlet.api.javax_servlet.filterrequestdispatcher;


import com.sun.ts.tests.servlet.common.util.ServletTestUtil;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;


public final class Test_Filter implements Filter {


    // The filter configuration object we are associated with.  If this value
    // is null, this filter instance is not currently configured.
    private FilterConfig filterConfig = null;


    public void doFilter(ServletRequest request, ServletResponse response,
                         FilterChain chain) throws IOException, ServletException {

        PrintWriter pw = response.getWriter();

        if (filterConfig == null) {
            ServletTestUtil.printResult(pw, "in Test_Filter");
        } else {
            ServletTestUtil.printResult(pw, true);
        }

    }


    // Remove the filter configuration object for this filter.
    public void destroy() {
    }


    //  initialize the filter configuration object for this filter.

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;

    }

}

