/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import com.sun.ant.taskdefs.common.EMMAGrabber;
import com.sun.ant.taskdefs.common.RunCTSProcIntf;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.Project;

public class RunCTSEmmaPostProcessor
implements RunCTSProcIntf {
    private boolean inited = false;
    private File tsHome;
    private File j2eeHome;
    private File emmaPropsFile;
    private File emmaJar;
    private File resultDir;
    private boolean prependTestData = true;
    private List grabbers = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Properties props, Project project) throws Exception {
        FileInputStream f = null;
        try {
            this.tsHome = new File(props.getProperty("ts.home"));
            this.j2eeHome = new File(props.getProperty("j2ee.home"));
            this.emmaPropsFile = new File(this.tsHome, "internal" + File.separator + "coverage" + File.separator + "emma.properties");
            this.emmaJar = new File(this.j2eeHome, "lib" + File.separator + "emma.jar");
            Properties emmaProps = new Properties();
            f = new FileInputStream(this.emmaPropsFile);
            emmaProps.load(f);
            this.resultDir = new File(emmaProps.getProperty("coverage.results.dir"));
            if (this.resultDir.isDirectory() && this.resultDir.list().length > 0) {
                throw new Exception("Results directory exists and is not empty \"" + this.resultDir.getPath() + "\"");
            }
            if (this.resultDir.isFile()) {
                throw new Exception("Results directory is a file \"" + this.resultDir.getPath() + "\"");
            }
            if (!this.resultDir.exists()) {
                this.resultDir.mkdirs();
            }
            this.prependTestData = Boolean.valueOf(emmaProps.getProperty("append.test.area.info.to.result.file"));
            Enumeration<?> propNames = emmaProps.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                if (propName.equals("coverage.results.dir") || propName.equals("append.test.area.info.to.result.file")) continue;
                this.grabbers.add(new EMMAGrabber(propName, emmaProps.getProperty(propName), this.resultDir, this.prependTestData, project, this.emmaJar.getPath()));
            }
        }
        finally {
            try {
                f.close();
            }
            catch (Exception e) {}
        }
    }

    public boolean execute(String currentTestDir, Project project, Properties props) throws Exception {
        project.log("***** POST PROCESSOR starting test area \"" + currentTestDir + "\"");
        if (!this.inited) {
            this.init(props, project);
            this.inited = true;
            project.log("***** Init Called");
        }
        String testArea = this.removeTSHome(currentTestDir);
        int numGrabbers = this.grabbers.size();
        for (int i = 0; i < numGrabbers; ++i) {
            EMMAGrabber grabber = (EMMAGrabber)this.grabbers.get(i);
            grabber.grab(testArea);
        }
        project.log("***** POST PROCESSSOR done test area \"" + currentTestDir + "\"");
        return true;
    }

    private String removeTSHome(String testarea) {
        int length = this.tsHome.getPath().length() + "/src/com/sun/ts/tests/".length();
        if (length >= testarea.length()) {
            return testarea;
        }
        return testarea.substring(length);
    }
}

