/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.securityapi.ham.sam.obtainbean;

import java.security.AccessController;
import java.security.PrivilegedAction;

import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.module.ServerAuthModule;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;


@WebListener
public class TestSamRegistrationInstaller implements ServletContextListener {
    
    private String registrationId;
    
    private String getAppContextID(ServletContext context) {
        return context.getVirtualServerName() + " " + context.getContextPath();
    }
    
    @Override
    public void contextInitialized(ServletContextEvent sce) {
        ServerAuthModule sam = new TestServerAuthModule();
        registrationId = AccessController.doPrivileged(new PrivilegedAction<String>() {
            public String run() {
                return AuthConfigFactory.getFactory().registerConfigProvider(
                        new TestAuthConfigProvider(sam),
                        "HttpServlet", 
                        getAppContextID(sce.getServletContext()), 
                        "Test single SAM authentication config provider"
                    );
            }
        });
    }
    
    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        AuthConfigFactory.getFactory().removeRegistration(registrationId);
    }
}
