/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javasoft.sqe.apiCheck.XClassField;
import javasoft.sqe.apiCheck.XClassMethod;
import javasoft.sqe.apiCheck.XType;
import javasoft.sqe.apiCheck.XTypeArray;
import javasoft.sqe.apiCheck.XTypeClass;
import javasoft.sqe.apiCheck.XTypePrimitive;

public class InheritedUtil {
    private static InheritedUtil instance = new InheritedUtil();
    private Map primMap = new HashMap();

    public static InheritedUtil instance() {
        return instance;
    }

    private InheritedUtil() {
        this.primMap.put("V", "void");
        this.primMap.put("Z", Boolean.TYPE);
        this.primMap.put("B", Byte.TYPE);
        this.primMap.put("S", Short.TYPE);
        this.primMap.put("I", Integer.TYPE);
        this.primMap.put("J", Long.TYPE);
        this.primMap.put("C", Character.TYPE);
        this.primMap.put("F", Float.TYPE);
        this.primMap.put("D", Double.TYPE);
    }

    private String createDimString(int numDims) {
        StringBuffer buf = new StringBuffer(numDims + 1);
        for (int i = 0; i < numDims; ++i) {
            buf.append("[");
        }
        return buf.toString();
    }

    private Class mapPrimitive(String prim) {
        Class result = null;
        if (this.primMap.containsKey(prim)) {
            result = (Class)this.primMap.get(prim);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Class[] createClassArray(Vector xclasses) throws Exception {
        int numClasses = xclasses == null ? 0 : xclasses.size();
        Class[] result = new Class[xclasses.size()];
        int i = 0;
        while (true) {
            block9: {
                Class<?> newType;
                String typeString;
                String dimString;
                block8: {
                    XType xtype;
                    block6: {
                        String prim;
                        block7: {
                            if (i >= numClasses) {
                                return result;
                            }
                            xtype = (XType)xclasses.elementAt(i);
                            dimString = "";
                            typeString = "";
                            if (xtype instanceof XTypeArray) {
                                dimString = this.createDimString(((XTypeArray)xtype).dims);
                                xtype = ((XTypeArray)xtype).ref;
                            }
                            if (!(xtype instanceof XTypePrimitive)) break block6;
                            prim = Character.toString(((XTypePrimitive)xtype).chr);
                            if (dimString.length() <= 0) break block7;
                            typeString = prim;
                            break block8;
                        }
                        result[i] = this.mapPrimitive(prim);
                        System.err.println("### Mapped Class \"" + result[i].getName() + "\"");
                        break block9;
                    }
                    if (xtype instanceof XTypeClass) {
                        typeString = ((XTypeClass)xtype).toString();
                        if (dimString.length() > 0) {
                            typeString = "L" + typeString + ";";
                        }
                    } else {
                        System.err.println("Unrecognized XType \"" + xtype + "\"");
                    }
                }
                System.err.println("#### Creating Class \"" + dimString + typeString + "\"");
                result[i] = newType = Class.forName(dimString + typeString);
            }
            ++i;
        }
    }

    private boolean methodModifiersOK(int mods, Class declaringClass, Class originalClass) {
        boolean result = false;
        if (Modifier.isAbstract(mods) || Modifier.isStatic(mods) || Modifier.isPrivate(mods)) {
            result = false;
        } else if (Modifier.isPublic(mods) || Modifier.isProtected(mods)) {
            result = true;
        } else if (declaringClass.getPackage().getName().equals(originalClass.getPackage().getName())) {
            result = true;
        }
        return result;
    }

    private void dumpThrows(Class[] inherited, Class[] original) {
        System.err.println("### Expected throws \"" + Arrays.asList(original) + "\"");
        System.err.println("### Found throws    \"" + Arrays.asList(inherited) + "\"");
    }

    private boolean throwsFound(String className, Class[] classes) {
        boolean result = false;
        for (int i = 0; i < classes.length; ++i) {
            if (!className.equals(classes[i].getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean throwsMatch(Class[] inherited, Class[] original) {
        boolean result = true;
        if (inherited.length != original.length) {
            System.err.println("### Throws list have differing length.");
            result = false;
        } else {
            for (int i = 0; i < inherited.length; ++i) {
                String className = inherited[i].getName();
                if (this.throwsFound(className, original)) continue;
                result = false;
                System.err.println("### Exception not found \"" + className + "\" in throws list.");
                break;
            }
        }
        if (!result) {
            this.dumpThrows(inherited, original);
        }
        return result;
    }

    private boolean isMethodInherited(Class clazz, String methodName, Class[] args, Class originalClass, Class[] originalThrows) {
        if (clazz == null) {
            System.err.println("### Method NOT inherited \"" + methodName + "()\"");
            return false;
        }
        Method m = null;
        System.err.println("### Checking class \"" + clazz.getName() + "\" for inherited method \"" + methodName + "()\"");
        try {
            boolean result;
            m = clazz.getDeclaredMethod(methodName, args);
            Class[] inheritedThrows = m.getExceptionTypes();
            boolean bl = result = this.methodModifiersOK(m.getModifiers(), clazz, originalClass) && this.throwsMatch(inheritedThrows, originalThrows);
            if (result) {
                System.err.println("### Method inherited from \"" + clazz.getName() + "." + methodName + "()\"");
            } else {
                System.err.println("### Method NOT inherited \"" + methodName + "()\"");
            }
            return result;
        }
        catch (NoSuchMethodException nsme) {
            System.err.println("### NOT FOUND \"" + clazz.getName() + "." + methodName + "()\"");
            return this.isMethodInherited(clazz.getSuperclass(), methodName, args, originalClass, originalThrows);
        }
    }

    public boolean methodIsInherited(XClassMethod method) throws Exception {
        System.err.println("### Calling methodIsInherited method name \"" + method.name + "()\"");
        String methodName = method.name;
        Class clazz = this.normalizedForName(method.home.FullName());
        Class superClass = clazz.getSuperclass();
        Class[] args = this.createClassArray(method.args);
        Class[] originalThrows = this.createClassArray(method.xthrows);
        return this.isMethodInherited(superClass, methodName, args, clazz, originalThrows);
    }

    public boolean methodIsOverridden(XClassMethod method) throws Exception {
        System.err.println("### Calling methodIsOverridden method name \"" + method.name + "()\"");
        return this.methodIsInherited(method);
    }

    private boolean fieldModifiersOK(int mods, Class declaringClass, Class originalClass) {
        boolean result = false;
        if (Modifier.isStatic(mods) || Modifier.isPrivate(mods)) {
            result = false;
        } else if (Modifier.isPublic(mods) || Modifier.isProtected(mods)) {
            result = true;
        } else if (declaringClass.getPackage().getName().equals(originalClass.getPackage().getName())) {
            result = true;
        }
        return result;
    }

    private boolean isFieldInherited(Class clazz, String fieldName, Class originalClass) throws Exception {
        if (clazz == null) {
            System.err.println("### Field NOT inherited \"" + fieldName + "\"");
            return false;
        }
        Field f = null;
        try {
            f = clazz.getDeclaredField(fieldName);
            int mods = f.getModifiers();
            boolean result = this.fieldModifiersOK(mods, clazz, originalClass);
            if (result) {
                System.err.println("### Field inherited from \"" + clazz.getName() + "." + fieldName + "\"");
            } else {
                System.err.println("### Field NOT inherited from \"" + clazz.getName() + "." + fieldName + "\"");
            }
            return result;
        }
        catch (NoSuchFieldException nsfe) {
            return this.isFieldInherited(clazz.getSuperclass(), fieldName, originalClass);
        }
    }

    public boolean fieldIsInherited(XClassField field) throws Exception {
        System.err.println("### Calling fieldIsInherited field name \"" + field.name + "\"");
        String fieldName = field.name;
        Class clazz = this.normalizedForName(field.home.FullName());
        Class superClass = clazz.getSuperclass();
        return this.isFieldInherited(superClass, fieldName, clazz);
    }

    public boolean fieldIsOverridden(XClassField field) throws Exception {
        System.err.println("### Calling fieldIsOverridden field name \"" + field.name + "\"");
        return this.fieldIsInherited(field);
    }

    private Class normalizedForName(String clazzName) throws Exception {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(clazzName);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not load class \"" + clazzName + "\"");
            System.err.println("Trying a nested version of the class name");
            int lastDot = clazzName.lastIndexOf(".");
            String normalizedClazzName = clazzName.substring(0, lastDot) + "$" + clazzName.substring(lastDot + 1);
            System.err.println("Normalized \"" + clazzName + " to \"" + normalizedClazzName + "\"");
            clazz = Class.forName(normalizedClazzName);
        }
        return clazz;
    }
}

