/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MimeHeaderTestServlet.java 62542 2011-04-15 16:55:08Z adf $
 */

package com.sun.ts.tests.saaj.api.javax_xml_soap.MimeHeader;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.tests.saaj.common.*;

import javax.servlet.http.*;
import javax.servlet.*;
import javax.xml.soap.*;
import javax.activation.DataHandler;
import java.net.*;
import java.io.*;
import java.util.*;

public class MimeHeaderTestServlet extends HttpServlet {
    private MessageFactory mf = null;
    private SOAPMessage msg = null;
    private SOAPPart sp = null;
    private SOAPEnvelope envelope = null;
    MimeHeader mimeHeader = null;

    private void setup() throws Exception 
    {
	TestUtil.logTrace("setup");

	SOAP_Util.setup();

	// Create a message from the message factory.
	TestUtil.logMsg("Create message from message factory");
	msg = SOAP_Util.getMessageFactory().createMessage();
            
        // Message creation takes care of creating the SOAPPart - a
        // required part of the message as per the SOAP 1.1
        // specification.
        sp = msg.getSOAPPart();
            
        // Retrieve the envelope from the soap part to start building
        // the soap message.
        envelope = sp.getEnvelope();
    }

    private void dispatch(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException 
    {
	TestUtil.logTrace("dispatch");
	String testname=SOAP_Util.getHarnessProps().getProperty("TESTNAME");
	if(testname.equals("getNameTest")) {
            TestUtil.logMsg("Starting getNameTest");
            getNameTest(req, res);
        } else if(testname.equals("getValueTest")) {
            TestUtil.logMsg("Starting getValueTest");
            getValueTest(req, res);
        } else {
	    throw new ServletException("The testname '"+testname+"' was not found in the test servlet");
      }
    }

    public void init(ServletConfig servletConfig) throws ServletException 
    {
	super.init(servletConfig);
        System.out.println("MimeHeaderTestServlet:init (Entering)");
        System.out.println("MimeHeaderTestServlet:init (Leaving)");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException 
    {
	TestUtil.logTrace("doGet");
	dispatch(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException 
    {
	TestUtil.logTrace("doPost");
	SOAP_Util.doServletPost(req, res);
	doGet(req, res);
    }

    private void getNameTest(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException 
    {
	TestUtil.logTrace("getNameTest");
	Properties resultProps = new Properties();
	boolean pass = true;

	res.setContentType("text/plain");
	PrintWriter out = res.getWriter();

	try {
	    setup();

	    TestUtil.logMsg("Creating MimeHeader object ...");
	    mimeHeader = new MimeHeader("Content-Type", "application/xml");

	    TestUtil.logMsg("Obtaining name");
	    String name = mimeHeader.getName();

	    TestUtil.logMsg("Validating name results ...");
	    if (name == null) {
		TestUtil.logErr("name is null");
		pass = false;
	    }
	    else if (!name.equals("Content-Type")) {
		TestUtil.logErr("name mismatch - expected: Content-Type, received: " +
				name);
		pass = false;
	    }
	    else
		TestUtil.logMsg("name matches: " + name);
	} catch(Exception e) {
	    TestUtil.logErr("Exception: " + e);
            TestUtil.printStackTrace(e);
	    pass = false;
	}
	// Send response object and test result back to client
	if(pass)
            resultProps.setProperty("TESTRESULT", "pass");
	else
            resultProps.setProperty("TESTRESULT", "fail");
        resultProps.list(out);
    }

    private void getValueTest(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException 
    {
	TestUtil.logTrace("getValueTest");
	Properties resultProps = new Properties();
	boolean pass = true;

	res.setContentType("text/plain");
	PrintWriter out = res.getWriter();

	try {
	    setup();

	    TestUtil.logMsg("Creating MimeHeader object ...");
	    mimeHeader = new MimeHeader("Content-Type", "application/xml");

	    TestUtil.logMsg("Obtaining value");
	    String value = mimeHeader.getValue();

	    TestUtil.logMsg("Validating value results ...");
	    if (value == null) {
		TestUtil.logErr("value is null");
		pass = false;
	    }
	    else if (!value.equals("application/xml")) {
		TestUtil.logErr("value mismatch - expected: application/xml, received: " +
				value);
		pass = false;
	    }
	    else
		TestUtil.logMsg("value matches: " + value);
	} catch(Exception e) {
	    TestUtil.logErr("Exception: " + e);
            TestUtil.printStackTrace(e);
	    pass = false;
	}
	// Send response object and test result back to client
	if(pass)
            resultProps.setProperty("TESTRESULT", "pass");
	else
            resultProps.setProperty("TESTRESULT", "fail");
        resultProps.list(out);
    }
}
