/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: BodyContentGetStringTag.java 62554 2011-04-15 18:08:28Z dougd $
 */

package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.bodycontent;

import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.JspException;
import java.io.IOException;

public class BodyContentGetStringTag extends BodyTagSupport {

    /**
     * Default constructor.
     */
    public BodyContentGetStringTag() {
	super();
    }

    /**
     * Validates BodyContent.getString()
     * 
     * @return SKIP_BODY
     * @throws JspException
     *             if an error occurs
     */
    public int doAfterBody() throws JspException {
	BodyContent content = this.getBodyContent();

	try {
	    String body = content.getString().trim();
	    
	    if (body.equals("body content")) {
		content.getEnclosingWriter().println("Test PASSED");
		
	    } else {
		content.getEnclosingWriter().println("Test FAILED.  Expected " +
			"BodyContent.getString() to return 'body content'.  "+
			"Received: " + body);
	    }

	} catch (Exception e) {
	    throw new JspException("Test FAILED. Unexpected Exception", e);
	}

	return SKIP_BODY;
    }
}
