/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jsonb.customizedmapping.serializers.model;

import java.util.ArrayList;
import java.util.List;

public class AnimalShelter {
    private List<Animal> animals = new ArrayList<>();

    public List<Animal> getAnimals() {
        return animals;
    }

    public void setAnimals(List<Animal> animals) {
        this.animals = animals;
    }

    public boolean addAnimal(Animal animal) {
        return animals.add(animal);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof AnimalShelter)) return false;

        AnimalShelter that = (AnimalShelter) o;

        return animals != null ? animals.equals(that.animals) : that.animals == null;
    }

    @Override
    public int hashCode() {
        return animals != null ? animals.hashCode() : 0;
    }
}
