/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: LinkedHashMap.java 62525 2011-04-15 12:14:31Z dougd $
 */

package com.sun.ts.tests.jsf.spec.el.managedbean.common;


import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>Simple {@link java.util.Map} to allow order validation of entries added by
 * the JSF implementation.
 */
public class LinkedHashMap extends HashMap {

    List linkedList;


    public LinkedHashMap() {
        super();
        linkedList = new LinkedList();
    }

    // ---------------------------------------------- Methods from java.util.Map


    /**
     * <p>In addition to the standard behavior of the HashMap, this stores the
     * keys in a {@link LinkedList}.</p>
     */
    public Object put(Object key, Object value) {

        linkedList.add(key);
        return super.put(key, value);

    } // END put


    // ---------------------------------------------------------- Public Methods


    /**
     * <p>Return the backing {@link LinkedList}.</p>
     */
    public List getKeyList() {

        return linkedList;

    } // END getKeyList


}
