/*
 * Copyright (c) 2008, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TitleConverter.java 62525 2011-04-15 12:14:31Z dougd $
 */
package com.sun.ts.tests.jsf.spec.composite.valueholder;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;

@FacesConverter(value="titleCase")
public class TitleConverter implements Converter {

    @Override
    public Object getAsObject(FacesContext context, UIComponent component,
            String value) {

        if(value == null || value.isEmpty()){
            return value;
        }

        System.out.println("(asObject)Before String: " + value);

        String old = value.substring(0, 1);
        return value.replaceFirst(old, old.toUpperCase());
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component,
            Object value) {

        if (value == null || value.toString().isEmpty()) {
            return null;
        }

        System.out.println("(asString)Before String: " + value);
        String old = value.toString().substring(0, 1);
        return value.toString().replaceFirst(old, old.toUpperCase());
    }
}