/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: OrderingBean.java 62525 2011-04-15 12:14:31Z dougd $
 */
package com.sun.ts.tests.jsf.spec.appconfigresources.common.beans;

import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;

import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.FactoryFinder;
import javax.faces.event.PhaseListener;

public class OrderingBean {

    private String [] suffixes;
    private int total;

    //Absolute Ordering
    public boolean isAbsoluteOrderCorrect(){
        suffixes = new String [] {"B", "C", "A", "D"};
        total = 4;

        return isOrderCorrect();
    }

    //Relative Ordering test 1
    public boolean isRelativeOneOrderCorrect(){
        suffixes = new String [] {"B", "C", "A"};
        total = 3;

        return isOrderCorrect();
    }

    //---------------------------------------------------------- private methods
    private boolean isOrderCorrect() {

        LifecycleFactory factory = (LifecycleFactory) FactoryFinder.getFactory(
                FactoryFinder.LIFECYCLE_FACTORY);
        Lifecycle l = factory.getLifecycle(LifecycleFactory.DEFAULT_LIFECYCLE);
        PhaseListener[] listeners = l.getPhaseListeners();
        List<PhaseListener> list = new ArrayList<PhaseListener>();
        for (PhaseListener listener : listeners) {
            if (listener.getClass().getName().contains(
                    "com.sun.ts.tests.jsf.spec.appconfigresources." +
                    "common.listeners.PhaseListener")) {
                list.add(listener);
            }
        }
        listeners = list.toArray(new PhaseListener[list.size()]);
        if (listeners.length != total) {
            System.out.println("INCORRECT LISTENER COUNT: " + listeners.length);

            for (int i = 0; listeners.length != i; i++) {
                System.out.println("LISTENER FOUND: " + listeners[i].getClass().
                        getName());
            }
            return false;
        }

        for (int i = 0; i < listeners.length; i++) {
            if (!listeners[i].getClass().getName().endsWith(suffixes[i])) {
                System.out.println("INCORRECT DOCUMENT ORDERING: " + Arrays.
                        toString(listeners));

                return false;
            }
        }

        return true;

    }
}
