/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 65758 2012-04-12 15:33:14Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.component.uiparameter;

import java.io.IOException;
import java.io.PrintWriter;

import com.sun.ts.tests.jsf.api.javax_faces.component.common.BaseComponentTestServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

import javax.faces.component.UIComponentBase;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectBoolean;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


public class TestServlet extends BaseComponentTestServlet {

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);     
        setRendererType(null);
    }


    /**
     * <p>Creates a new {@link javax.faces.component.UIComponent} instance.</p>
     * 
     * @return a new {@link javax.faces.component.UIComponent} instance.
     */
    @Override
    protected UIComponentBase createComponent() {
        return new UIParameter();
    }
    
// ------------------------------------------- Test Methods ----
    
// ------------------------------------------- UIparameter Tests
    
    public void uiParameterSetGetNameTest(HttpServletRequest request,
	    HttpServletResponse response) throws ServletException, IOException {
	PrintWriter out = response.getWriter();
	UIParameter param = (UIParameter) createComponent();
	String golden = "Frodo";
	
	param.setName(golden);
	String result = param.getName();

	if (!result.equals(golden)) {
	    out.println(JSFTestUtil.FAIL
		    + " UIParameter.getName() didn't return"
		    + " the value as set by UIParameter.setName().");
	    out.println("Expected: " + golden);
	    out.println("Received: " + result);
	    return;
	}

	out.println(JSFTestUtil.PASS);
	
    } // uiParameterSetGetNameTest
  
    public void uiParameterSetGetValueTest(HttpServletRequest request,
	    HttpServletResponse response) throws ServletException, IOException {
	PrintWriter out = response.getWriter();
	UIParameter param = (UIParameter) createComponent();
	boolean golden = true;
	
	param.setValue(golden);
	boolean result = (Boolean) param.getValue();

	if (!result) {
	    out.println(JSFTestUtil.FAIL
		    + " UIParameter.getValue() didn't return"
		    + " the value as set by UIParameter.setValue().");
	    out.println("Expected: " + golden);
	    out.println("Received: " + result);
	    return;
	}

	out.println(JSFTestUtil.PASS);
	
    } // uiParameterSetGetValueTest
    
    public void uiParameterIsSetDisableTest(HttpServletRequest request,
	    HttpServletResponse response) throws ServletException, IOException {
	PrintWriter out = response.getWriter();
	UIParameter param = (UIParameter) createComponent();
	boolean golden = true;
	
	param.setDisable(golden);
	boolean result = (Boolean) param.isDisable();

	if (!result) {
	    out.println(JSFTestUtil.FAIL
		    + " UIParameter.isDisable() didn't return"
		    + " the value as set by UIParameter.setDisable().");
	    out.println("Expected: " + golden);
	    out.println("Received: " + result);
	    return;
	}

	out.println(JSFTestUtil.PASS);
	
    } // uiParameterIsSetDisableTest
}
