/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Invoker;

public class InvokerImpl
extends Invoker {
    private Hashtable invokersCache = new Hashtable();
    private GeneratedClassLoader cachedClassLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Invoker createInvoker(ClassCache cache, Method method, Class[] types) {
        GeneratedClassLoader classLoader;
        Invoker result = (Invoker)this.invokersCache.get(method);
        if (result != null) {
            return result;
        }
        String className = "inv" + cache.newClassSerialNumber();
        ClassFileWriter cfw = new ClassFileWriter(className, "org.mozilla.javascript.Invoker", "");
        cfw.setFlags((short)17);
        cfw.startMethod("<init>", "()V", (short)1);
        cfw.add(42);
        cfw.addInvoke(183, "org.mozilla.javascript.Invoker", "<init>", "()V");
        cfw.add(177);
        cfw.stopMethod((short)1);
        cfw.startMethod("invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", (short)17);
        String declaringClassName = method.getDeclaringClass().getName().replace('.', '/');
        Class<?> returnType = method.getReturnType();
        String invokeSpecial = null;
        String invokeSpecialType = null;
        boolean returnsVoid = false;
        boolean returnsBoolean = false;
        if (returnType.isPrimitive()) {
            if (returnType == Boolean.TYPE) {
                returnsBoolean = true;
                invokeSpecialType = "(Z)V";
            } else if (returnType == Void.TYPE) {
                returnsVoid = true;
                invokeSpecialType = "()V";
            } else if (returnType == Integer.TYPE) {
                invokeSpecial = "java/lang/Integer";
                cfw.add(187, "java/lang/Integer");
                cfw.add(89);
                invokeSpecialType = "(I)V";
            } else if (returnType == Long.TYPE) {
                invokeSpecial = "java/lang/Long";
                cfw.add(187, "java/lang/Long");
                cfw.add(89);
                invokeSpecialType = "(J)V";
            } else if (returnType == Short.TYPE) {
                invokeSpecial = "java/lang/Short";
                cfw.add(187, "java/lang/Short");
                cfw.add(89);
                invokeSpecialType = "(S)V";
            } else if (returnType == Float.TYPE) {
                invokeSpecial = "java/lang/Float";
                cfw.add(187, "java/lang/Float");
                cfw.add(89);
                invokeSpecialType = "(F)V";
            } else if (returnType == Double.TYPE) {
                invokeSpecial = "java/lang/Double";
                cfw.add(187, "java/lang/Double");
                cfw.add(89);
                invokeSpecialType = "(D)V";
            } else if (returnType == Byte.TYPE) {
                invokeSpecial = "java/lang/Byte";
                cfw.add(187, "java/lang/Byte");
                cfw.add(89);
                invokeSpecialType = "(B)V";
            } else if (returnType == Character.TYPE) {
                invokeSpecial = "java/lang/Character";
                cfw.add(187, "java/lang/Character");
                cfw.add(89);
                invokeSpecialType = "(C)V";
            }
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            cfw.add(43);
            cfw.add(192, declaringClassName);
        }
        StringBuffer params = new StringBuffer(2 + (types != null ? 20 * types.length : 0));
        params.append('(');
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                Class type = types[i];
                cfw.add(44);
                if (i <= 5) {
                    cfw.add((byte)(3 + i));
                } else if (i <= 127) {
                    cfw.add(16, i);
                } else if (i <= Short.MAX_VALUE) {
                    cfw.add(17, i);
                } else {
                    cfw.addLoadConstant(i);
                }
                cfw.add(50);
                if (type.isPrimitive()) {
                    if (type == Boolean.TYPE) {
                        cfw.add(192, "java/lang/Boolean");
                        cfw.addInvoke(182, "java/lang/Boolean", "booleanValue", "()Z");
                        params.append('Z');
                        continue;
                    }
                    if (type == Integer.TYPE) {
                        cfw.add(192, "java/lang/Number");
                        cfw.addInvoke(182, "java/lang/Number", "intValue", "()I");
                        params.append('I');
                        continue;
                    }
                    if (type == Short.TYPE) {
                        cfw.add(192, "java/lang/Number");
                        cfw.addInvoke(182, "java/lang/Number", "shortValue", "()S");
                        params.append('S');
                        continue;
                    }
                    if (type == Character.TYPE) {
                        cfw.add(192, "java/lang/Character");
                        cfw.addInvoke(182, "java/lang/Character", "charValue", "()C");
                        params.append('C');
                        continue;
                    }
                    if (type == Double.TYPE) {
                        cfw.add(192, "java/lang/Number");
                        cfw.addInvoke(182, "java/lang/Number", "doubleValue", "()D");
                        params.append('D');
                        continue;
                    }
                    if (type == Float.TYPE) {
                        cfw.add(192, "java/lang/Number");
                        cfw.addInvoke(182, "java/lang/Number", "floatValue", "()F");
                        params.append('F');
                        continue;
                    }
                    if (type != Byte.TYPE) continue;
                    cfw.add(192, "java/lang/Byte");
                    cfw.addInvoke(182, "java/lang/Byte", "byteValue", "()B");
                    params.append('B');
                    continue;
                }
                String typeName = type.getName().replace('.', '/');
                cfw.add(192, typeName);
                if (!type.isArray()) {
                    params.append('L');
                }
                params.append(typeName);
                if (type.isArray()) continue;
                params.append(';');
            }
        }
        params.append(')');
        if (invokeSpecialType != null) {
            if (returnsVoid) {
                params.append('V');
            } else {
                params.append(invokeSpecialType.charAt(1));
            }
        } else if (returnType.isArray()) {
            params.append(returnType.getName().replace('.', '/'));
        } else {
            params.append('L');
            params.append(returnType.getName().replace('.', '/'));
            params.append(';');
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            cfw.addInvoke(182, declaringClassName, method.getName(), params.toString());
        } else {
            cfw.addInvoke(184, declaringClassName, method.getName(), params.toString());
        }
        if (returnsVoid) {
            cfw.add(1);
            cfw.add(176);
        } else if (returnsBoolean) {
            cfw.add(153, 7);
            cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            cfw.add(176);
            cfw.add(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
            cfw.add(176);
        } else if (invokeSpecial != null) {
            cfw.addInvoke(183, invokeSpecial, "<init>", invokeSpecialType);
            cfw.add(176);
        } else {
            cfw.add(176);
        }
        cfw.stopMethod((short)3);
        byte[] bytes = cfw.toByteArray();
        boolean canCache = cache.isCachingEnabled();
        InvokerImpl invokerImpl = this;
        synchronized (invokerImpl) {
            if (canCache && this.cachedClassLoader != null) {
                classLoader = this.cachedClassLoader;
            } else {
                Context cx = Context.getCurrentContext();
                ClassLoader parentLoader = cx.getApplicationClassLoader();
                classLoader = cx.createClassLoader(parentLoader);
                if (canCache) {
                    this.cachedClassLoader = classLoader;
                }
            }
        }
        Class c = classLoader.defineClass(className, bytes);
        classLoader.linkClass(c);
        try {
            result = (Invoker)c.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("unexpected " + e.toString());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unexpected " + e.toString());
        }
        if (canCache) {
            this.invokersCache.put(method, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMasterCaches() {
        InvokerImpl invokerImpl = this;
        synchronized (invokerImpl) {
            this.cachedClassLoader = null;
        }
        this.invokersCache = new Hashtable();
    }

    public Object invoke(Object that, Object[] args) {
        return null;
    }
}

