/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.accessibility.AccessibleContext;
import javax.help.HelpBroker;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

class SearchDialog
extends JDialog {
    private ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(SearchDialog.FIND)) {
                SearchDialog.this.find();
            } else if (cmd.equals(SearchDialog.CLOSE)) {
                SearchDialog.this.setVisible(false);
            } else if (cmd.equals(SearchDialog.HELP)) {
                SearchDialog.this.helpBroker.setCurrentID(SearchDialog.this.helpPrefix + "search.csh");
                SearchDialog.this.helpBroker.setDisplayed(true);
            }
        }
    };
    private Interview interview;
    private Question currentQuestion;
    private HelpBroker helpBroker;
    private String helpPrefix;
    private JTextField textField;
    private JComboBox whereChoice;
    private JCheckBox caseChk;
    private JCheckBox wordChk;
    private static final String ANSWER = "answer";
    private static final String ANYWHERE = "anywhere";
    private static final String CLOSE = "close";
    private static final String FIND = "find";
    private static final String HELP = "help";
    private static final String QUESTION = "question";
    private static final String TITLE = "title";
    private static final KeyStroke escapeKey = KeyStroke.getKeyStroke("ESCAPE");
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    static SearchDialog create(Component parent, Interview i, HelpBroker helpBroker, String helpPrefix) {
        Dialog d = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, parent);
        if (d != null) {
            return new SearchDialog(d, i, helpBroker, helpPrefix);
        }
        Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        return new SearchDialog(f, i, helpBroker, helpPrefix);
    }

    SearchDialog(Frame parent, Interview i, HelpBroker helpBroker, String helpPrefix) {
        super(parent);
        this.init(parent, i, helpBroker, helpPrefix);
    }

    SearchDialog(Dialog parent, Interview i, HelpBroker helpBroker, String helpPrefix) {
        super(parent);
        this.init(parent, i, helpBroker, helpPrefix);
    }

    private void init(Component parent, Interview i, HelpBroker helpBroker, String helpPrefix) {
        this.interview = i;
        this.helpBroker = helpBroker;
        this.helpPrefix = helpPrefix;
        this.setName(FIND);
        this.setTitle(i18n.getString("find.title"));
        AccessibleContext ac = this.getAccessibleContext();
        ac.setAccessibleName(i18n.getString("find.name"));
        ac.setAccessibleDescription(i18n.getString("find.desc"));
        Container contentPane = this.getContentPane();
        contentPane.setName("content");
        contentPane.setFocusable(false);
        contentPane.setLayout(new BorderLayout());
        JPanel p = new JPanel(new GridBagLayout());
        p.setName("main");
        p.setFocusable(false);
        GridBagConstraints lc = new GridBagConstraints();
        lc.anchor = 13;
        lc.insets.right = 10;
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        JLabel textLbl = this.createLabel("find.field", true);
        p.add((Component)textLbl, lc);
        this.textField = new JTextField("", 32);
        this.textField.setName("find.text");
        this.textField.addActionListener(this.listener);
        this.textField.setActionCommand(FIND);
        this.textField.setToolTipText(textLbl.getAccessibleContext().getAccessibleDescription());
        textLbl.setLabelFor(this.textField);
        c.insets.bottom = 10;
        p.add((Component)this.textField, c);
        JLabel whereLbl = this.createLabel("find.where", true);
        p.add((Component)whereLbl, lc);
        String[] choices = new String[]{TITLE, QUESTION, ANSWER, ANYWHERE};
        this.whereChoice = this.createChoice("find.where", choices);
        whereLbl.setLabelFor(this.whereChoice);
        c.anchor = 17;
        c.fill = 0;
        c.insets.bottom = 0;
        p.add((Component)this.whereChoice, c);
        JLabel optionsLbl = this.createLabel("find.options", false);
        p.add((Component)optionsLbl, lc);
        JPanel p2 = new JPanel();
        p2.setName("options");
        p2.setFocusable(false);
        this.caseChk = this.createCheckBox("find.case");
        p2.add(this.caseChk);
        this.wordChk = this.createCheckBox("find.word");
        p2.add(this.wordChk);
        p.add((Component)p2, c);
        p.registerKeyboardAction(this.listener, CLOSE, escapeKey, 1);
        p.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        contentPane.add((Component)p, "Center");
        JPanel btns = new JPanel(new GridBagLayout());
        btns.setName("btns");
        btns.setFocusable(false);
        c = new GridBagConstraints();
        c.weightx = 1.0;
        c.anchor = 13;
        btns.add((Component)this.createButton("find.find", FIND, this.listener), c);
        c.insets.left = 5;
        c.weightx = 0.0;
        btns.add((Component)this.createButton("find.close", CLOSE, this.listener), c);
        if (helpBroker != null) {
            btns.add((Component)this.createButton("find.help", HELP, this.listener), c);
        }
        btns.setBorder(BorderFactory.createEmptyBorder(11, 12, 11, 11));
        contentPane.add((Component)btns, "South");
        if (helpBroker != null) {
            helpBroker.enableHelpKey(this.getRootPane(), helpPrefix + "search.csh", null);
        }
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.textField.requestFocus();
        }
    }

    public void find() {
        if (this.textField.getText().length() == 0) {
            this.setVisible(true);
        } else {
            Hashtable answers = new Hashtable();
            this.interview.save(answers);
            Question[] path = this.interview.getPath();
            Question curr = this.interview.getCurrentQuestion();
            for (int i = 0; i < path.length; ++i) {
                if (path[i] != curr) continue;
                for (int j = 0; j < path.length; ++j) {
                    Question q = path[(i + 1 + j) % path.length];
                    String answer = (String)answers.get(q.getTag());
                    if (!this.matches(q, answer, this.caseChk.isSelected(), this.wordChk.isSelected())) continue;
                    try {
                        this.interview.setCurrentQuestion(q);
                    }
                    catch (Interview.Fault e) {
                        // empty catch block
                    }
                    return;
                }
                this.getToolkit().beep();
                return;
            }
        }
    }

    private boolean matches(Question q, String answer, boolean considerCase, boolean word) {
        String text = this.textField.getText();
        String where = (String)this.whereChoice.getSelectedItem();
        if (where.equals(TITLE)) {
            return SearchDialog.match(text, q.getSummary(), considerCase, word);
        }
        if (where.equals(QUESTION)) {
            return SearchDialog.match(text, q.getText(), considerCase, word);
        }
        if (where.equals(ANSWER)) {
            return answer != null && SearchDialog.match(text, answer, considerCase, word);
        }
        return SearchDialog.match(text, q.getSummary(), considerCase, word) || SearchDialog.match(text, q.getText(), considerCase, word) || answer != null && SearchDialog.match(text, answer, considerCase, word);
    }

    private static boolean match(String s1, String s2, boolean considerCase, boolean word) {
        int s1len = s1.length();
        int s2len = s2.length();
        for (int i = 0; i <= s2len - s1len; ++i) {
            if (!s1.regionMatches(!considerCase, 0, s2, i, s1len)) continue;
            if (word) {
                return !(i != 0 && !SearchDialog.isBoundaryCh(s2.charAt(i - 1)) || i + s1len != s2.length() && !SearchDialog.isBoundaryCh(s2.charAt(i + s1len)));
            }
            return true;
        }
        return false;
    }

    private static boolean isBoundaryCh(char c) {
        return !Character.isUnicodeIdentifierStart(c) && !Character.isUnicodeIdentifierPart(c);
    }

    private JButton createButton(String uiKey, String actionCommand, ActionListener l) {
        JButton b = new JButton(i18n.getString(uiKey + ".btn"));
        b.setName(uiKey);
        b.setMnemonic(this.getMnemonic(uiKey));
        b.setActionCommand(actionCommand);
        b.addActionListener(l);
        this.setToolTipText(b, uiKey);
        return b;
    }

    private JCheckBox createCheckBox(String uiKey) {
        JCheckBox b = new JCheckBox(i18n.getString(uiKey + ".ckb"));
        b.setName(uiKey);
        b.setMnemonic(this.getMnemonic(uiKey));
        this.setToolTipText(b, uiKey);
        return b;
    }

    private JComboBox createChoice(String uiKey, final String[] choiceKeys) {
        final String[] choices = new String[choiceKeys.length];
        for (int i = 0; i < choices.length; ++i) {
            choices[i] = i18n.getString(uiKey + "." + choiceKeys[i] + ".chc");
        }
        JComboBox<String> choice = new JComboBox<String>(choiceKeys);
        choice.setName(uiKey);
        AccessibleContext ac = choice.getAccessibleContext();
        ac.setAccessibleName(i18n.getString(uiKey + ".tip"));
        choice.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object o, int index, boolean isSelected, boolean cellHasFocus) {
                Object c = o;
                for (int i = 0; i < choiceKeys.length; ++i) {
                    if (choiceKeys[i] != o) continue;
                    c = choices[i];
                    break;
                }
                return super.getListCellRendererComponent((JList<?>)list, c, index, isSelected, cellHasFocus);
            }
        });
        this.setToolTipText(choice, uiKey);
        ac.setAccessibleDescription(choice.getToolTipText());
        return choice;
    }

    private JLabel createLabel(String uiKey, boolean needMnemonic) {
        JLabel l = new JLabel(i18n.getString(uiKey + ".lbl"));
        l.setName(uiKey);
        if (needMnemonic) {
            l.setDisplayedMnemonic(this.getMnemonic(uiKey));
        }
        this.setToolTipText(l, uiKey);
        return l;
    }

    private char getMnemonic(String uiKey) {
        return i18n.getString(uiKey + ".mne").charAt(0);
    }

    private void setToolTipText(JComponent c, String uiKey) {
        c.setToolTipText(i18n.getString(uiKey + ".tip"));
    }
}

