/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.se.schemaGeneration.annotations.secondaryTable;

import javax.persistence.*;

@Entity
@Table(name = "SCHEMAGENSIMPLE")
@SecondaryTable(name = "SCHEMAGENSIMPLE_SECOND", pkJoinColumns = @PrimaryKeyJoinColumn(name = "SECONDARY_ID"), foreignKey = @ForeignKey(name = "MYCONSTRAINT", value=ConstraintMode.CONSTRAINT, foreignKeyDefinition ="FOREIGN KEY (SECONDARY_ID) REFERENCES SCHEMAGENSIMPLE (SIMPLEID)" ))
@Inheritance(strategy = InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name = "PRODUCT_TYPE", discriminatorType = DiscriminatorType.STRING)
@DiscriminatorValue("Product")
public class Simple implements java.io.Serializable {


    // ===========================================================
    // instance variables
    int simple_id;

    // ===========================================================
    // constructors
    public Simple() {
    }

    public Simple(int id) {
        this.simple_id = id;
    }


    @Id
    public int getSimpleId() {
        return simple_id;
    }

    public void setSimpleId(int id) {
        this.simple_id = id;
    }

     @Override
    public boolean equals(Object o) {
        //check for self-comparison
        if (this == o) return true;
        if (!(o instanceof Simple)) return false;

        Simple o1 = (Simple) o;

        boolean result = false;

        if (this.getSimpleId() == o1.getSimpleId() ) {
            result = true;
        }

        return result;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getSimpleId());
        result.append("]");
        return result.toString();
    }

}
