/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.metamodelapi.metamodel;

import javax.persistence.Embeddable;
import javax.persistence.Embedded;

@Embeddable
public class Address implements java.io.Serializable{

    protected String street;
    protected String city;
    protected String state;   
   
    @Embedded
    protected ZipCode zipcode;
    
    public Address(){
    }

    public Address(String street, String city, String state) {
        this.street = street;
        this.city = city;
        this.state = state;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getStreet() {
        return street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public ZipCode getZipCode() {
        return zipcode;
    }

    public void setZipCode(ZipCode zipcode) {
        this.zipcode = zipcode;
    }
}
