/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.derivedid.ex1b;

import javax.persistence.Embeddable;

/**
 *
 * @author Raja Perumal
 */

@Embeddable
public class DID1bDependentId implements java.io.Serializable {

    String name;
    long empPK;    

    public DID1bDependentId() {
    }

    public DID1bDependentId(String name, long emp) {
        this.name = name;
        this.empPK = emp;
    }

    public long getEmpPK() {
        return empPK;
    }

    public void setEmpPK(long emp) {
        this.empPK = emp;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (int) empPK;
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DID1bDependentId)) {
            return false;
        }
        DID1bDependentId other = (DID1bDependentId) object;
        if (this.empPK != other.empPK || this.name== null ||  !(other.name.equals(this.name))) {
            return false;
        }
        return true;
    }
}
